/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于日志接口测试用例
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2021.5.11
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported tc_logger_create */
/* exported tc_logger_insert_log_right */
/* exported tc_logger_insert_log_error */
/* exported tc_logger_insert_max_log */
/* exported tc_logger_reset */

/* global mc_ui_logger */

var g_o_log = new mc_ui_logger();

function tc_logger_create(callback) {
    var o_log = new mc_ui_logger();

    if (check_constrcut(o_log)) {
        callback(1);
        return;
    }

    callback(0, "创建失败");
}

function check_constrcut(o) {
    if ("object" === typeof o && o.constructor === mc_ui_logger) {
        return true;
    }

    return false;
}

function tc_logger_insert_log_right(callback) {
    if (!check_constrcut(g_o_log)) {
        return false;
    }

    var a_res = [
        g_o_log.debug("这是一条debug日志1"),
        g_o_log.debug(" debug日志2 "),
        g_o_log.infor("这是一条消息日志1"),
        g_o_log.infor("infor2"),
        g_o_log.warn("这是一条警告日志1"),
        g_o_log.warn("warn2"),
        g_o_log.error("这是一条错误日志1"),
        g_o_log.error("error2"),
        g_o_log.fatal("fatal1"),
        g_o_log.fatal("7845")
    ];

    if ( -1 !== a_res.indexOf(false) ) {
        return callback(0);
    }

    return callback(1);
}

function tc_logger_insert_log_error(callback) {
    var no;

    var a_res = [
        g_o_log.debug(no) ,
        g_o_log.debug(0) ,
        g_o_log.infor() ,
        g_o_log.infor(0) ,
        g_o_log.warn(null) ,
        g_o_log.warn(true) ,
        g_o_log.error([]) ,
        g_o_log.error(-1) ,
        g_o_log.fatal(no) ,
        g_o_log.fatal({
            d: 5
        })
    ];

    if ( -1 !== a_res.indexOf(true) ) {
        return callback(0);
    }

    return callback(1);
}


function tc_logger_reset(callback) {
    var o_log = new mc_ui_logger();

    if (!check_constrcut(o_log)) {
        return;
    }

    o_log.debug("");
    o_log.debug(0);
    o_log.infor("");
    o_log.infor("infor");
    o_log.warn("warn");
    o_log.warn("warn2");
    o_log.error("error");
    o_log.error("error2");
    o_log.fatal("fatal1");
    o_log.debug("这是一条debug日志1");
    o_log.debug(" debug日志2 ");
    o_log.infor("这是一条消息日志1");
    o_log.infor("infor2");
    o_log.warn("这是一条警告日志1");
    o_log.warn("warn2");
    o_log.error("这是一条错误日志1");
    o_log.error("error2");
    o_log.fatal("fatal1");
    o_log.fatal("7845");

    o_log.reset();

    var a_log = o_log.get_log_txt();

    if ("object" === typeof a_log && 100000 === a_log.length && "string" !== typeof a_log[0]) {
        callback(1);
        return;
    }

    callback(0);
    return;
}

function tc_logger_insert_max_log(callback) {
    var o_log = new mc_ui_logger();

    if (!check_constrcut(o_log)) {
        return;
    }

    o_log.reset();

    for (let i = 0; 99999 > i; i++) {
        o_log.debug("debug" + [i + 1]);
    }

    for (let i = 0; 3 > i; i++) {
        o_log.error("error" + [i + 1]);
    }

    let log_txt = o_log.get_log_txt();

    //判断当日志长度大于最大值时 && 第一条和最后一条的类型等于插入的日志数据类型
    if (
        100000 <= log_txt.length &&
        "DEBUG" === log_txt[0].split(" ")[4] &&
        "ERROR" === log_txt[99999].split(" ")[4]
    ) {
        callback(1);
        return;
    }

    callback(0);
}
